package main

import (
	"encoding/csv"
	"encoding/xml"
	"fmt"
	"os"
)

// XMLデータの構造体定義
type Dataset struct {
	Items []OccurredConcentratedTrafficVolumeOfPersonTrip `xml:"Occurred_ConcentratedTrafficVolumeOfPersonTrip"`
}

type OccurredConcentratedTrafficVolumeOfPersonTrip struct {
	ID                                       string `xml:"id,attr"`
	UrbanArea                                int    `xml:"urbanArea"`
	SurveyYear                               int    `xml:"surveyYear"`
	ConcentratedOccurrence                   int    `xml:"concentratedOccurrence"`
	ZoneCode                                 int    `xml:"zoneCode"`
	Railroad_NumberOfTripsForGoingToWork     int    `xml:"railroad_NumberOfTripsForGoingToWork"`
	Railroad_NumberOfTripsForGoingToSchool   int    `xml:"railroad_NumberOfTripsForGoingToSchool"`
	Railroad_NumberOfFreeTrips               int    `xml:"railroad_NumberOfFreeTrips"`
	Railroad_NumberOfBusinessTrips           int    `xml:"railroad_NumberOfBusinessTrips"`
	Railroad_NumberOfTripsForGoingHome       int    `xml:"railroad_NumberOfTripsForGoingHome"`
	Railroad_TotalNumberOfTrips              int    `xml:"railroad_TotalNumberOfTrips"`
	Bus_NumberOfTripsForGoingToWork          int    `xml:"bus_NumberOfTripsForGoingToWork"`
	Bus_NumberOfTripsForGoingToSchool        int    `xml:"bus_NumberOfTripsForGoingToSchool"`
	Bus_NumberOfFreeTrips                    int    `xml:"bus_NumberOfFreeTrips"`
	Bus_NumberOfBusinessTrips                int    `xml:"bus_NumberOfBusinessTrips"`
	Bus_NumberOfTripsForGoingHome            int    `xml:"bus_NumberOfTripsForGoingHome"`
	Bus_TotalNumberOfTrips                   int    `xml:"bus_TotalNumberOfTrips"`
	Automobile_NumberOfTripsForGoingToWork   int    `xml:"automobile_NumberOfTripsForGoingToWork"`
	Automobile_NumberOfTripsForGoingToSchool int    `xml:"automobile_NumberOfTripsForGoingToSchool"`
	Automobile_NumberOfFreeTrips             int    `xml:"automobile_NumberOfFreeTrips"`
	Automobile_NumberOfBusinessTrips         int    `xml:"automobile_NumberOfBusinessTrips"`
	Automobile_NumberOfTripsForGoingHome     int    `xml:"automobile_NumberOfTripsForGoingHome"`
	Automobile_TotalNumberOfTrips            int    `xml:"automobile_TotalNumberOfTrips"`
	Motorcycle_NumberOfTripsForGoingToWork   int    `xml:"motorcycle_NumberOfTripsForGoingToWork"`
	Motorcycle_NumberOfTripsForGoingToSchool int    `xml:"motorcycle_NumberOfTripsForGoingToSchool"`
	Motorcycle_NumberOfFreeTrips             int    `xml:"motorcycle_NumberOfFreeTrips"`
	Motorcycle_NumberOfBusinessTrips         int    `xml:"motorcycle_NumberOfBusinessTrips"`
	Motorcycle_NumberOfTripsForGoingHome     int    `xml:"motorcycle_NumberOfTripsForGoingHome"`
	Motorcycle_TotalNumberOfTrips            int    `xml:"motorcycle_TotalNumberOfTrips"`
	Walk_NumberOfTripsForGoingToWork         int    `xml:"walk_NumberOfTripsForGoingToWork"`
	Walk_NumberOfTripsForGoingToSchool       int    `xml:"walk_NumberOfTripsForGoingToSchool"`
	Walk_NumberOfFreeTrips                   int    `xml:"walk_NumberOfFreeTrips"`
	Walk_NumberOfBusinessTrips               int    `xml:"walk_NumberOfBusinessTrips"`
	Walk_NumberOfTripsForGoingHome           int    `xml:"walk_NumberOfTripsForGoingHome"`
	Walk_TotalNumberOfTrips                  int    `xml:"walk_TotalNumberOfTrips"`
	TotalNumberOfTrips                       int    `xml:"totalNumberOfTrips"`
}

func main() {
	// XMLファイルを読み込む
	xmlData, err := os.Open("sample1.xml")
	if err != nil {
		fmt.Println("Error opening XML file:", err)
		return
	}
	defer xmlData.Close()

	// XMLデータをデコード
	var dataset Dataset
	decoder := xml.NewDecoder(xmlData)
	if err := decoder.Decode(&dataset); err != nil {
		fmt.Println("Error decoding XML:", err)
		return
	}

	// CSVファイルにデータを書き込み
	csvFile, err := os.Create("output.csv")
	if err != nil {
		fmt.Println("Error creating CSV file:", err)
		return
	}
	defer csvFile.Close()

	csvWriter := csv.NewWriter(csvFile)
	defer csvWriter.Flush()

	// CSVヘッダを書き込み
	headers := []string{
		"ID", "UrbanArea", "SurveyYear", "ConcentratedOccurrence", "ZoneCode",
		"Railroad_NumberOfTripsForGoingToWork", "Railroad_NumberOfTripsForGoingToSchool", "Railroad_NumberOfFreeTrips",
		"Railroad_NumberOfBusinessTrips", "Railroad_NumberOfTripsForGoingHome", "Railroad_TotalNumberOfTrips",
		"Bus_NumberOfTripsForGoingToWork", "Bus_NumberOfTripsForGoingToSchool", "Bus_NumberOfFreeTrips",
		"Bus_NumberOfBusinessTrips", "Bus_NumberOfTripsForGoingHome", "Bus_TotalNumberOfTrips",
		"Automobile_NumberOfTripsForGoingToWork", "Automobile_NumberOfTripsForGoingToSchool", "Automobile_NumberOfFreeTrips",
		"Automobile_NumberOfBusinessTrips", "Automobile_NumberOfTripsForGoingHome", "Automobile_TotalNumberOfTrips",
		"Motorcycle_NumberOfTripsForGoingToWork", "Motorcycle_NumberOfTripsForGoingToSchool", "Motorcycle_NumberOfFreeTrips",
		"Motorcycle_NumberOfBusinessTrips", "Motorcycle_NumberOfTripsForGoingHome", "Motorcycle_TotalNumberOfTrips",
		"Walk_NumberOfTripsForGoingToWork", "Walk_NumberOfTripsForGoingToSchool", "Walk_NumberOfFreeTrips",
		"Walk_NumberOfBusinessTrips", "Walk_NumberOfTripsForGoingHome", "Walk_TotalNumberOfTrips",
		"TotalNumberOfTrips",
	}

	if err := csvWriter.Write(headers); err != nil {
		fmt.Println("Error writing CSV headers:", err)
		return
	}

	// データをCSVに書き込み
	//for _, person := range root.Persons {
	for _, item := range dataset.Items {

		// fmt.Println("pass1")
		// fmt.Println(item)

		//record := []string{item.ID, fmt.Sprintf("%d", item.UrbanArea), fmt.Sprintf("%d", item.SurveyYear), fmt.Sprintf("%d", item.ConcentratedOccurrence), fmt.Sprintf("%d", item.ZoneCode)}

		record := []string{
			item.ID,
			fmt.Sprintf("%d", item.UrbanArea),
			fmt.Sprintf("%d", item.SurveyYear),
			fmt.Sprintf("%d", item.ConcentratedOccurrence),
			fmt.Sprintf("%d", item.ZoneCode),
			fmt.Sprintf("%d", item.Railroad_NumberOfTripsForGoingToWork),
			fmt.Sprintf("%d", item.Railroad_NumberOfTripsForGoingToSchool),
			fmt.Sprintf("%d", item.Railroad_NumberOfFreeTrips),
			fmt.Sprintf("%d", item.Railroad_NumberOfBusinessTrips),
			fmt.Sprintf("%d", item.Railroad_NumberOfTripsForGoingHome),
			fmt.Sprintf("%d", item.Railroad_TotalNumberOfTrips),
			fmt.Sprintf("%d", item.Bus_NumberOfTripsForGoingToWork),
			fmt.Sprintf("%d", item.Bus_NumberOfTripsForGoingToSchool),
			fmt.Sprintf("%d", item.Bus_NumberOfFreeTrips),
			fmt.Sprintf("%d", item.Bus_NumberOfBusinessTrips),
			fmt.Sprintf("%d", item.Bus_NumberOfTripsForGoingHome),
			fmt.Sprintf("%d", item.Bus_TotalNumberOfTrips),
			fmt.Sprintf("%d", item.Automobile_NumberOfTripsForGoingToWork),
			fmt.Sprintf("%d", item.Automobile_NumberOfTripsForGoingToSchool),
			fmt.Sprintf("%d", item.Automobile_NumberOfFreeTrips),
			fmt.Sprintf("%d", item.Automobile_NumberOfBusinessTrips),
			fmt.Sprintf("%d", item.Automobile_NumberOfTripsForGoingHome),
			fmt.Sprintf("%d", item.Automobile_TotalNumberOfTrips),
			fmt.Sprintf("%d", item.Motorcycle_NumberOfTripsForGoingToWork),
			fmt.Sprintf("%d", item.Motorcycle_NumberOfTripsForGoingToSchool),
			fmt.Sprintf("%d", item.Motorcycle_NumberOfFreeTrips),
			fmt.Sprintf("%d", item.Motorcycle_NumberOfBusinessTrips),
			fmt.Sprintf("%d", item.Motorcycle_NumberOfTripsForGoingHome),
			fmt.Sprintf("%d", item.Motorcycle_TotalNumberOfTrips),
			fmt.Sprintf("%d", item.Walk_NumberOfTripsForGoingToWork),
			fmt.Sprintf("%d", item.Walk_NumberOfTripsForGoingToSchool),
			fmt.Sprintf("%d", item.Walk_NumberOfFreeTrips),
			fmt.Sprintf("%d", item.Walk_NumberOfBusinessTrips),
			fmt.Sprintf("%d", item.Walk_NumberOfTripsForGoingHome),
			fmt.Sprintf("%d", item.Walk_TotalNumberOfTrips),
			fmt.Sprintf("%d", item.TotalNumberOfTrips),
		}

		if err := csvWriter.Write(record); err != nil {
			fmt.Println("Error writing CSV record:", err)
			return
		}

	}

	fmt.Println("CSV file successfully created.")
}
